unit main;

interface

uses Unit2,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls;

type
  TfrmMain = class(TForm)
    MesText: TMemo;
    btnExit: TBitBtn;
    btnSend: TBitBtn;
    Label1: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    Bevel3: TBevel;
    Bevel4: TBevel;
    Bevel5: TBevel;
    AddrBox: TComboBox;
    btnAbout: TBitBtn;
    StatusLabel: TLabel;
    procedure btnSendClick(Sender: TObject);
    procedure btnAboutClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MesTextChange(Sender: TObject);
    procedure AddrBoxChange(Sender: TObject);
  private
    UserName : string;
    MessageHeader : TStringList;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses about;

{$R *.DFM}


procedure TfrmMain.btnSendClick(Sender: TObject);
var
  i, res: Integer;
begin
  if AddrBox.Text <> '' then
  begin
    StatusLabel.Font.Color := clBlack;
    StatusLabel.Caption := 'Wait... ';
    Update;
    if AddrBox.Items.IndexOf(AddrBox.Text) = -1 then
      AddrBox.Items.Add(AddrBox.Text);
    res := SendMsg(AddrBox.Text,'',MessageHeader.Text+mesText.Text);
    if res = 0 then
      frmMain.StatusLabel.Font.Color := clBlue
    else
      frmMain.StatusLabel.Font.Color := clRed;
    case res of
      0    : frmMain.StatusLabel.Caption := 'The message is sent';
      87   : frmMain.StatusLabel.Caption := 'The parameter is incorrect';
      123  : frmMain.StatusLabel.Caption := 'sintax is incorrect';
      2273 : frmMain.StatusLabel.Caption := 'Can not find '+frmMain.AddrBox.Text;
    else     frmMain.StatusLabel.Caption := 'Error: '+IntToStr(res);
    end;
  end;
end;

procedure TfrmMain.btnAboutClick(Sender: TObject);
begin
  frmAbout.ShowModal;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
  strUser : PChar;
  strSize : DWord;
begin
  strUser := StrAlloc(100);
  strSize := 100;
  GetUserName(strUser,strSize);
  UserName := strUser;
  StrDispose(strUser);
  MessageHeader := TStringList.Create;
  MessageHeader.Add('---------------------------------');
  MessageHeader.Add('    from '+UserName);
  MessageHeader.Add('---------------------------------');
end;


procedure TfrmMain.MesTextChange(Sender: TObject);
begin
  StatusLabel.Caption := ' ';
end;

procedure TfrmMain.AddrBoxChange(Sender: TObject);
begin
  StatusLabel.Caption := ' ';
end;

end.
